/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.tiles.machine;

import fr.iglee42.evolvedmekanism.interfaces.ChemixerCachedRecipe;
import fr.iglee42.evolvedmekanism.interfaces.EMInputRecipeCache;
import fr.iglee42.evolvedmekanism.recipes.ChemixerRecipe;
import fr.iglee42.evolvedmekanism.registries.EMBlocks;
import fr.iglee42.evolvedmekanism.registries.EMRecipeType;
import java.util.List;
import java.util.Set;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.ITripleRecipeLookupHandler;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityProgressMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityChemixer
extends TileEntityProgressMachine<ChemixerRecipe>
implements ITripleRecipeLookupHandler.ObjectObjectChemicalRecipeLookupHandler<ItemStack, ItemStack, Gas, GasStack, ChemixerRecipe, EMInputRecipeCache.ItemItemChemical<Gas, GasStack, ChemixerRecipe>> {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_ITEM_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SECONDARY_INPUT = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_GAS_INPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, NOT_ENOUGH_ITEM_INPUT_ERROR, NOT_ENOUGH_SECONDARY_INPUT, NOT_ENOUGH_GAS_INPUT_ERROR, NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final int BASE_DURATION = 100;
    private static final long MAX_GAS = 10000L;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getInputGas", "getInputGasCapacity", "getInputGasNeeded", "getInputGasFilledPercentage"}, docPlaceholder="gas input")
    public IGasTank inputGasTank;
    private final IOutputHandler<@NotNull ItemStack> outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    private final IInputHandler<@NotNull GasStack> gasInputHandler;
    private MachineEnergyContainer<TileEntityChemixer> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="item input slot")
    InputInventorySlot mainInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryInput"}, docPlaceholder="secondary input slot")
    InputInventorySlot extraInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="item output slot")
    OutputInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityChemixer(BlockPos pos, BlockState state) {
        super(EMBlocks.CHEMIXER, pos, state, TRACKED_ERROR_TYPES, 100);
        this.configComponent = new TileComponentConfig((TileEntityMekanism)this, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.GAS});
        this.configComponent.setupItemIOExtraConfig((IInventorySlot)this.mainInputSlot, (IInventorySlot)this.outputSlot, (IInventorySlot)this.extraInputSlot, (IInventorySlot)this.energySlot);
        this.configComponent.setupInputConfig(TransmissionType.GAS, (Object)this.inputGasTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.GAS}).setCanTankEject(tank -> tank != this.inputGasTank);
        this.itemInputHandler = InputHelper.getInputHandler((IInventorySlot)this.mainInputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_ITEM_INPUT_ERROR);
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.extraInputSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
        this.gasInputHandler = InputHelper.getInputHandler((IChemicalTank)this.inputGasTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_GAS_INPUT_ERROR);
        this.outputHandler = OutputHelper.getOutputHandler((IInventorySlot)this.outputSlot, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR);
    }

    @NotNull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks(IContentsListener listener, IContentsListener recipeCacheListener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideGasWithConfig(() -> ((TileEntityChemixer)this).getDirection(), () -> ((TileEntityChemixer)this).getConfig());
        this.inputGasTank = (IGasTank)ChemicalTankBuilder.GAS.create(10000L, (gas, type) -> type != AutomationType.EXTERNAL, (gas, automationType) -> this.containsRecipeCAB(this.mainInputSlot.getStack(), this.extraInputSlot.getStack(), (Chemical)gas), arg_0 -> ((TileEntityChemixer)this).containsRecipeC(arg_0), ChemicalAttributeValidator.ALWAYS_ALLOW, recipeCacheListener);
        builder.addTank((IChemicalTank)this.inputGasTank);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(() -> ((TileEntityChemixer)this).getDirection(), () -> ((TileEntityChemixer)this).getConfig());
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(() -> ((TileEntityChemixer)this).getDirection(), () -> ((TileEntityChemixer)this).getConfig());
        this.mainInputSlot = InputInventorySlot.at(item -> this.containsRecipeABC(item, this.extraInputSlot.getStack(), (GasStack)this.inputGasTank.getStack()), arg_0 -> ((TileEntityChemixer)this).containsRecipeA(arg_0), (IContentsListener)recipeCacheListener, (int)64, (int)17);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.mainInputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(NOT_ENOUGH_ITEM_INPUT_ERROR)));
        this.extraInputSlot = InputInventorySlot.at(item -> this.containsRecipeBAC(this.mainInputSlot.getStack(), item, (GasStack)this.inputGasTank.getStack()), arg_0 -> ((TileEntityChemixer)this).containsRecipeB(arg_0), (IContentsListener)recipeCacheListener, (int)64, (int)53);
        ((InputInventorySlot)builder.addSlot((IInventorySlot)this.extraInputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT)));
        this.outputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)116, (int)35);
        ((OutputInventorySlot)builder.addSlot((IInventorySlot)this.outputSlot)).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(NOT_ENOUGH_SPACE_ITEM_OUTPUT_ERROR)));
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemixer)this).m_58904_(), (IContentsListener)listener, (int)141, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot);
        return builder.build();
    }

    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.recipeCacheLookupMonitor.updateAndProcess();
    }

    @NotNull
    public IMekanismRecipeTypeProvider<ChemixerRecipe, EMInputRecipeCache.ItemItemChemical<Gas, GasStack, ChemixerRecipe>> getRecipeType() {
        return EMRecipeType.CHEMIXING;
    }

    @Nullable
    public ChemixerRecipe getRecipe(int cacheIndex) {
        return (ChemixerRecipe)this.findFirstRecipe(this.itemInputHandler, this.extraInputHandler, this.gasInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemixerRecipe> createNewCachedRecipe(@NotNull ChemixerRecipe recipe, int cacheIndex) {
        return new ChemixerCachedRecipe(recipe, this.recheckAllRecipeErrors, this.itemInputHandler, this.extraInputHandler, this.gasInputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(arg_0 -> ((TileEntityChemixer)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setRequiredTicks(() -> ((TileEntityChemixer)this).getTicksRequired()).setOnFinish(() -> ((TileEntityChemixer)this).markForSave()).setOperatingTicksChanged(x$0 -> this.setOperatingTicks(x$0));
    }

    public MachineEnergyContainer<TileEntityChemixer> getEnergyContainer() {
        return this.energyContainer;
    }

    @ComputerMethod(methodDescription="Get the energy used in the last tick by the machine")
    FloatingLong getEnergyUsage() {
        return this.getActive() ? this.energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
    }
}

